#include <bits/stdc++.h>

using namespace std;

using ll = long long;

int ispisi;

const int INF = 1e9 + 12;

void solve() {
    //drzati minimalan i maksimalan broj polja kojih mozemo da posetimo ako smo na trenutnom?
    int n, m, k;
    cin >> n >> m >> k;

    vector<string> mat(n);
    for(auto &z : mat) cin >> z;

    vector<vector<int>> mini(n, vector<int>(m, INF)), maksi(n, vector<int>(m, -INF));

    for(int i = n - 1; i >= 0; --i) {
        for(int j = m - 1; j >= 0; --j) {
            int trenutno = mat[i][j] - '0';

            if(i == n - 1 && j == m - 1) {
                mini[i][j] = maksi[i][j] = trenutno;
                continue;
            }

            if(i + 1 < n) {
                mini[i][j] = min(mini[i][j], mini[i + 1][j] + trenutno);
                maksi[i][j] = max(maksi[i][j], maksi[i + 1][j] + trenutno);
            }

            if(j + 1 < m) {
                mini[i][j] = min(mini[i][j], mini[i][j + 1] + trenutno);
                maksi[i][j] = max(maksi[i][j], maksi[i][j + 1] + trenutno);
            }
        }
    }

    bool moze = (k >= mini[0][0] && k <= maksi[0][0]);

    if(!moze) {
        cout << "NE" << '\n';
        return;
    }

    cout << "DA" << '\n';

    if(ispisi == 0) {
        return;
    }

    int posetili = 0;

    pair<int, int> trenutno{0, 0};

    string ans;

    while(trenutno != make_pair(n - 1, m - 1)) {
        posetili += mat[trenutno.first][trenutno.second] - '0';

        int potrebnoJos = k - posetili;

        if((trenutno.first + 1 < n) && (potrebnoJos >= mini[trenutno.first + 1][trenutno.second] && potrebnoJos <= maksi[trenutno.first + 1][trenutno.second])) {
            trenutno.first++;
            ans += "S";
            continue;
        }

        if((trenutno.second + 1 < m) && (potrebnoJos >= mini[trenutno.first][trenutno.second + 1] && potrebnoJos <= maksi[trenutno.first][trenutno.second + 1])) {
            trenutno.second++;
            ans += "D";
            continue;
        }
    }

    cout << ans << '\n';
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int t;
    cin >> t >> ispisi;
    while(t--) solve();
}